-- SQL: Structured Query Language: Veritabannda sorgular zerinden veritaban ilemleri yapabildiimiz dildir.
-- T-SQL: Transact Structured Query Language: Microsoft SQL Server'n kulland zelletirilmi SQL'dir.

-- T-SQL'de yorum satrlar -- ... ile ... olan yer iin tek satr olarak veya /* ... */ ile ... olan yer iin birden ok
-- satr eklinde yazlr.

-- DATA DEFINITION LANGUAGE (DDL): Veritabannda veriyi sakladmz veya kullandmz yaplar oluturmak, deitirmek 
-- veya silmek iin kullanlr.

-- rnek olarak database (veritaban), table (tablo), column(stun) ve view'ler (dinamik grnmler) iin 
-- DDL sorgular altrlabilir.

-- DDL sorgular kullanlmadan da Microsoft SQL Server design sayfalar zerinden veritaban, tablo, tablolar aras ilikiler
-- vb. ilemleri yaplabilir.

-- master: Sunucudaki veritabanlarmzn yaplaryla ilgili verilerin sakland veritabandr.

-- ki altrlan SQL sorgusu arasna go konularak mutlaka birincinin ileminin bitmesi salanabilir, daha sonra dieri alr.

-- Yeni bir veritaban oluturulurken nce master veritaban zerinden oluturucamz veritaban (Filmler) var m kontrol yaplr,
-- eer varsa bu veritaban drop database Filmler sorgusu ile silinir.

-- create database Filmler ile yeni veritaban oluturulur.

-- use Filmler ile Filmler veritabannn kullanlmas salanr, sonrasnda sorgular Filmler veritaban zerinde alacaktr.

-- create table Film ile yeni tablo oluturulur. Bu tablo Yonetmen ile 1 to many, Tur ile many to many ilikilidir.

-- primary key (birincil anahtar): Bir tablodaki her bir satrda tanmland stun iin tekil veri tutulmasn salar.

-- identity(1, 1): identity ile bu verinin soldaki 1 deeri ile 1'den balamas, sadaki 1 deeri ile de birer birer artmas salanr.
-- Eer veritabannn bu veriyi otomatik arttrmas istenmiyorsa identity(1, 1) yazmaya gerek yoktur.

-- foreign key (yabancl anahtar): Bir tabloya ilikili olduu baka tablodan tanan ve tand tabloda primary key olan stundur.

-- bigint, int, smallint, tinyint ve bit saklayabildikleri deerler bakmndan bykten ke doru tam say verilerinin 
-- tutulmas iin kullanlan veri tipleridir.

-- varchar, char ve text metinsel verilerin tutulmas iin kullanlan veri tipleridir.

-- varchar(uzunluk) ve char(uzunluk) ile parantez iinde maksimum ka karakter metinsel veri tutulabilecei yani uzunluk belirtilir.
-- varchar(max) ve char(max) ile SQL Server'da tanml olan ve versiyonlara gre deien maksimum karakter says tanmlanabilir.
-- text iin max tanmlamaya gerek yoktur, bu veri tipi ok byk metinsel verilerin tutulmas iin kullanlr.

-- Tutulan varchar verisinin uzunluu girilen veriye gre deiirken char verinin uzunluu sabittir, 
-- veri girilmeyen karakterler boluk olarak tutulur.

-- Eer veritabannn collation' (verileri saklamak iin kulland dil) Trke (TURKISH_CI_AS) olarak tanmlanmamsa metinsel
-- veri tiplerinin bana n konularak (nvarchar, nchar, ntext) bu verilerin unicode karakter kmesi kullanlarak saklanmas 
-- salanr ki Trke veriler iin bir sorun olmasn. Bu ekilde tanmlanan stunlara veri girilirken de bana N eklenir.

-- null: Veri girii yaplan stunda hi bir verinin saklanmamas iin kullanlr, zel bir bo veri olarak dnlebilir.

-- Ondalk veriler iin genel olarak float veri tipi kullanlr.

-- Ondalk saylarda tam ksm ile ondalkl ksm zelletirmeleri iin decimal veri tipi kullanlabilir.
-- rnein decimal(9, 2) bize saynn nokta ile beraber 9 hane olacan, 2 ise noktadan sonraki hane saysn belirtir.

-- Para verisi de ondalk say olduundan money veri tipi ile zelletirilmi ve kullanmmza sunulmutur.

-- Tarih verilerinde sadece tarih iin date veri tipi, tarih ve saat iinse datetime veri tipi tanmlanabilir.
-- T-SQL tarih format: yl-ay-gn saat:dakika:saniye.milisaniye (rnek: 2021-09-07 17:25:50.123)

-- Metinsel olmayan yani ikilik sistemde oluturulmu imaj gibi veriler image, varbinary(uzunluk) veya binary(uzunluk) veri tipleriyle saklanabilir.

-- alter komutu veritaban dahil herhangi bir veritaban yapsnn deitirilmesi iin kullanlr.
-- rnein database, table, column ve view'ler iin kullanlabilir.

-- drop komutu veritaban dahil herhangi bir veritaban yapsnn silinmesi iin kullanlr.
-- rnein database, table, column ve view'ler iin kullanlabilir.

use master
go
if exists (select name from sys.databases where name = 'Filmler')
begin
	alter database Filmler set single_user with rollback immediate -- veritaban balantsn koparmak iin zel sorgu
	drop database Filmler -- veritabann silen esas sorgu
end
go
create database Filmler
go
use Filmler
go
create table Film -- Yonetmen ile 1 to many tablosu, Tur ile many to many tablosu, FilmDetay ile 1 to 1 tablosu
(
	Id int primary key identity(1, 1), -- 1. primary key tanmlama yntemi
	Adi varchar(300) not null,
	YapimYili char(4),
	YonetmenId int null, -- null: Herhangi bir filmin ynetmeni olmayabilir, not null: Her filmin bir ynetmeni olmaldr.
						 -- Yonetmen tablosundan tand iin foreign key'dir.
						 -- Eer stunda null verilere izin verilecekse null yazmaya gerek yoktur.
	Gisesi money,
	HataliSutun int -- rnek iin silinecek stun
)
create table FilmDetay -- Film ile 1 to 1 tablosu
(
	FilmId int primary key,
	Maliyeti decimal(9, 2) not null,
	Aciklamasi varchar(MAX)
)
create table Yonetmen
(
	Id int primary key identity(1, 1),
	Adi varchar(50) not null,
	Soyadi varchar(50) not null,
	DogumTarihi date,
	EmekliMi bit
)
create table Tur
(
	Id int primary key identity(1, 1),
	Adi varchar(1) -- rnek iin dzeltilecek stun
)
create table FilmTur -- Film ve Tur iin many to many tablosu
(
	FilmId int not null, -- Film tablosundan tand iin foreign key'dir.
	TurId int not null, -- Tur tablosundan tand iin foreign key'dir.
	constraint PK_FilmTur PRIMARY KEY (FilmId, TurId) -- 2. primary key tanmlama yntemi, 
													  -- burada olduu gibi birden ok stun primary key olarak tanmlanabilir.
)
create table Hatalitablo -- rnek iin silinecek tablo
(
	Id int primary key
)

alter table Tur alter column Adi varchar(25) not null -- rnek iin Tur tablosundaki adi stununun veri tipini 
												      -- null girilemeyecek ekilde varchar(25) olarak deitiriyoruz.
alter table Film drop column HataliSutun -- rnek iin Film tablosundaki hatal stunu siliyoruz.

drop table Hatalitablo -- rnek iin hatal oluturduumuz tabloyu siliyoruz.

-- Tablolar aras ilikiler:

-- Film ile Yonetmen arasndaki 1 to many iliki iin Film tablosuna bir foreign key constraint (kstlama) ekleyerek
-- bu constraint'in Film tablosundaki yonetmenid ile Yonetmen tablosundaki id stunlar iin olduunu belirtiyoruz.
alter table Film add constraint FK_Film_Yonetmen foreign key (YonetmenId) references Yonetmen(Id)

-- Dolaysyla Film ile Yonetmen tablolar arasnda 1 to many iliki oluturmu oluyoruz.

-- Film ile FilmTur arasndaki 1 to many iliki iin FilmTur tablosuna bir foreign key constraint ekleyerek
-- bu constraint'in FilmTur tablosundaki filmid ile Film tablosundaki id stunlar iin olduunu belirtiyoruz.
alter table FilmTur add constraint FK_FilmTur_Film foreign key (FilmId) references Film(Id)

-- Tur ile FilmTur arasndaki 1 to many iliki iin FilmTur tablosuna bir foreign key constraint ekleyerek
-- bu constraint'in FilmTur tablosundaki turid ile Tur tablosundaki id stunlar iin olduunu belirtiyoruz.
alter table FilmTur add constraint FK_FilmTur_Tur foreign key (TurId) references Tur(Id)

-- Dolaysyla Film ile Tur tablolar arasnda many to many iliki oluturmu oluyoruz.

-- Film ile FilmDetay arasndaki 1 to 1 iliki iin FilmDetay tablosuna bir foreign key constraint ekleyerek
-- bu constraint'in Film tablosundaki id ile FilmDetay tablosundaki filmid stunlar iin olduunu belirtiyoruz.
alter table FilmDetay add constraint FK_FilmDetay_Film foreign key (FilmId) references Film(Id)